package gov.va.genisis2.ms.converter;

import java.util.HashSet;
import java.util.Set;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.ms.data.model.ConceptMapping;
import gov.va.genisis2.ms.data.model.ConceptMappingDataElement;
import gov.va.genisis2.ts.common.dto.ConceptMappingDataElementDTO;

@Component
public class ConceptMappingDataElementConverter
		implements Converter<ConceptMappingDataElement, ConceptMappingDataElementDTO> {

	@Override
	public ConceptMappingDataElementDTO convert(ConceptMappingDataElement entity) {
		ConceptMappingDataElementDTO dto = new ConceptMappingDataElementDTO();

		dto.setId(entity.getId());
		dto.setConceptUri(entity.getConceptUri());
		dto.setDataElementId(entity.getDataElementId());
		dto.setConceptMappingId(entity.getConceptMappingId());

		return dto;
	}

	public ConceptMappingDataElement convert(ConceptMappingDataElementDTO dto) {
		ConceptMappingDataElement entity = new ConceptMappingDataElement();

		entity.setId(dto.getId());
		entity.setConceptUri(dto.getConceptUri());
		entity.setDataElementId(dto.getDataElementId());
		entity.setConceptMappingId(dto.getConceptMappingId());

		return entity;
	}

	public Set<ConceptMappingDataElementDTO> convert(Set<ConceptMappingDataElement> dataElements) {
		Set<ConceptMappingDataElementDTO> dtos = new HashSet<>();

		if (null != dataElements && !dataElements.isEmpty()) {
			for (ConceptMappingDataElement dataElement : dataElements) {
				dtos.add(convert(dataElement));
			}
		}

		return dtos;
	}
	
	public Set<ConceptMappingDataElement> convertDataElements(Set<ConceptMappingDataElementDTO> dataElementDtos, ConceptMapping conceptMapping) {
		Set<ConceptMappingDataElement> dtos = new HashSet<>();

		if (null != dataElementDtos && !dataElementDtos.isEmpty()) {
			for (ConceptMappingDataElementDTO dataElementDto : dataElementDtos) {
				ConceptMappingDataElement dataElement = convert(dataElementDto);
				dataElement.setConceptUri(conceptMapping.getConceptUri());
				dataElement.setConceptMapping(conceptMapping);
				dtos.add(dataElement);
			}
		}

		return dtos;
	}
}
